EvaluateScript("flik_menu.js")

///////////////////////////////////////////////////////////

function StatusWindow()
{
	DrawTimer = false;
	UnselectableColor = CreateColor(219, 236, 245);
	var window = LoadWindowStyle("window.rws");
  
  	var menu = DefaultMapMenu(16, 16);
  	var descriptions = ["View your inventory", "Use your hard-earned experince", "Back to the game!", "Quit the game"];

  	menu.addText("Inventory", function() { menu.slide (16, 16, -160, 16, 200); InventoryMenu(); menu.slide (-160, 16, 16, 16, 200);   });

  	menu.addText("Level-up",  function() { menu.slide (16, 16, -160, 16, 200); LevelMenu(); menu.slide (-160, 16, 16, 16, 200);  });
  	//menu.items[menu.items.length - 1].isSelectable = function() { return false; }
  			
  	menu.addText("Return",  function() { menu.slide (16, 16, -160, 16, 200); menu.preRender(); menu.draw(); menu.done = true;  });
  	menu.addText("Quit",  function() { menu.slide (16, 16, -160, 16, 200); menu.done = true; Exit(); });

  	menu.preRender = function() {
		RenderMap();
		window.drawWindow(menu.getX(), menu.getY(), menu.getWidth(), menu.getHeight());
		window.drawWindow(menu.getX()+128, menu.getY(), 96, 144);
		menu.getFont().drawText(128+menu.getX(),16,"HP: "+People[Player].hp+"/"+People[Player].getMaxHP());
		menu.getFont().drawText(128+menu.getX(),32,"---------- ");
		menu.getFont().drawText(128+menu.getX(),48,"STR: "+People[Player].str);
		menu.getFont().drawText(128+menu.getX(),64,"DEX: "+People[Player].dex);
		menu.getFont().drawText(128+menu.getX(),80,"LCK: "+People[Player].lck);
		menu.getFont().drawText(128+menu.getX(),96,"----------");
		menu.getFont().drawText(128+menu.getX(),112,"EXP: "+People[Player].xp);
		menu.getFont().drawText(128+menu.getX(),144,"Gold: "+People[Player].gold);
  		menu.getFont().drawText(16+menu.getX(), GetScreenHeight() - 32, descriptions[menu.selection]);		
	}

	menu.slide (-160, 16, 16, 16, 200);

	menu.execute();

	DrawTimer = true;
}

///////////////////////////////////////////////////////////

function MainMenu(scroll)
{
	var x = 320/2
	var y = 240/2
	if (scroll == undefined) scroll = 0

	var window = LoadWindowStyle("window.rws")
	var mountain = LoadImage("mountain3.png")
	var title = LoadImage("title.png")

	var menu = DefaultMenu(16,16);

	menu.addText("New Game",  function() { FadeOutMenu(2000); menu.done = true; NewGame() });
	menu.addText("Load Game",  function() { menu.slide (120, 180,-100, 180,  200); menu.done = true; LoadMenu(scroll) });
	//menu.addText("Disable Grass",  function() { menu.slide (120, 180,-100, 180,  200); menu.done = true; GrassOff = true; MainMenu(scroll) });
	menu.addText("Quit",  function() { menu.slide (120, 180,-100, 180,  200); menu.done = true; Exit(); });

	menu.preRender = function() {
		UpdateProcess_Manager_Run()
		//bg.blit(0,0)
		mountain.blit(0-scroll,100);
		mountain.blit(400-scroll,100);
		scroll += .5;
		
		title.blit(0,0);
		if (scroll == 400) scroll = 0;
		window.drawWindow(menu.getX(), menu.getY(), menu.getWidth(), menu.getHeight());
	}
	
	menu.slide (-100, 180,120, 180,  200)

	return menu.execute()	
}

///////////////////////////////////////////////////////////

function LoadMenu(scroll)
{
	var x = 320/2
	var y = 240/2
	if (scroll == undefined) scroll = 0

	var window = LoadWindowStyle("window.rws")
	var mountain = LoadImage("mountain3.png")
	var title = LoadImage("title.png")

	var menu = DefaultMenu(16,16);

	menu.addText("Return",  function() { menu.slide (20, 180,-100, 180,  200);  menu.done = true; MainMenu(scroll); });
  
	var stats = GetGameStats("slot1.sav")
  
	if (stats[0] == -200) 
	{
		menu.addText("Slot 1: Empty",  function() { menu.slide (20, 180,-100, 180,  200); menu.done = true; LoadGame("slot1.sav") });
		menu.items[menu.items.length - 1].isSelectable = function() { return false }
	}
	else
	{
		menu.addText("Slot 1: Day "+stats[0]+", "+stats[1]+"/"+stats[2]+"/"+stats[3],  function() { FadeOutMenu(2000); menu.done = true; LoadGame("slot1.sav") });		
	}
  
	stats = GetGameStats("slot2.sav")
  
	if (stats[0] == -200) 
	{
		menu.addText("Slot 2: Empty",  function() { menu.slide (20, 180,-100, 180,  200); menu.done = true; LoadGame("slot2.sav") });
		menu.items[menu.items.length - 1].isSelectable = function() { return false }
	}
	else
	{
		menu.addText("Slot 2: Day "+stats[0]+", "+stats[1]+"/"+stats[2]+"/"+stats[3],  function() { FadeOutMenu(2000); menu.done = true; LoadGame("slot2.sav") });		
	}
 
	stats = GetGameStats("slot3.sav")
  
	if (stats[0] == -200) 
	{
		menu.addText("Slot 3: Empty",  function() { menu.slide (20, 180,-100, 180,  200); menu.done = true; LoadGame("slot3.sav") });
		menu.items[menu.items.length - 1].isSelectable = function() { return false }
	}
	else
	{
		menu.addText("Slot 3: Day "+stats[0]+", "+stats[1]+"/"+stats[2]+"/"+stats[3],  function() { FadeOutMenu(2000); menu.done = true;  LoadGame("slot3.sav") });		
	}

	menu.preRender = function() {
		//bg.blit(0,0);
		UpdateProcess_Manager_Run();
		mountain.blit(0-scroll,100);
		mountain.blit(400-scroll,100);
		scroll += .5;
		
		title.blit(0,0);
		if (scroll == 400) scroll = 0;
		window.drawWindow(menu.getX(), menu.getY(), menu.getWidth(), menu.getHeight());
	}
	
	menu.slide (-100, 180,20, 180,  200);
	
	return menu.execute();
}

///////////////////////////////////////////////////////////

function SaveMenu()
{
	var window = LoadWindowStyle("window.rws")
	var menu = DefaultMapMenu(16,16);

	menu.addText("Return",  function() { menu.slide (20, 180,-100, 180,  200);  menu.done = true; });
  
  	var stats = GetGameStats("slot1.sav")
  
	if (stats[0] == -200) 
	{
		menu.addText("Slot 1: Empty",  function() { menu.slide (20, 180,-100, 180,  200); menu.done = true; SaveGame("slot1.sav") });
	}
	else
	{
		menu.addText("Slot 1: Day "+stats[0]+", "+stats[1]+"/"+stats[2]+"/"+stats[3],  function() { menu.slide (20, 180,-100, 180,  200); menu.done = true; SaveGame("slot1.sav") });		
	}
  
  	stats = GetGameStats("slot2.sav")
  
	if (stats[0] == -200) 
	{
		menu.addText("Slot 2: Empty",  function() { menu.slide (20, 180,-100, 180,  200); menu.done = true; SaveGame("slot2.sav") });
	}
	else
	{
		menu.addText("Slot 2: Day "+stats[0]+", "+stats[1]+"/"+stats[2]+"/"+stats[3],  function() { menu.slide (20, 180,-100, 180,  200); menu.done = true; SaveGame("slot2.sav") });		
	}
  
  	stats = GetGameStats("slot3.sav")
  
	if (stats[0] == -200) 
	{
		menu.addText("Slot 3: Empty",  function() { menu.slide (20, 180,-100, 180,  200); menu.done = true; SaveGame("slot3.sav") });
	}
	else
	{
		menu.addText("Slot 3: Day "+stats[0]+", "+stats[1]+"/"+stats[2]+"/"+stats[3],  function() { menu.slide (20, 180,-100, 180,  200); menu.done = true; SaveGame("slot3.sav") });		
	}

  	menu.preRender = function() {
		RenderMap()
		window.drawWindow(menu.getX(), menu.getY(), menu.getWidth(), menu.getHeight())
  	}
	
	menu.slide (-100, 180,20, 180,  200);

	return menu.execute();
}

///////////////////////////////////////////////////////////

function InventoryMenu(map)
{
	var menu = DefaultMapMenu(16, 16,240,180);
	var descriptions = ["Back to the status window"];
	
	menu.addDefaultGridKeys(1, 3);
	menu.vertical = false;
	menu.horizontal = true;

	var x = 0
	var Combined_Width = 0
	var y = 0
	menu.setNextX(menu.x + Combined_Width );
	menu.setNextY(menu.y + 16 * y);					  

  	menu.addText("Return",  function() { menu.slide (16, 16, -300, 16, 200); menu.done = true; });
  	x+=1 
  	Combined_Width+= 8*10
  
  	for (var i = 0; i < People[Player].inventory.length; i++)
	{
		//if (x != 0)
		//	{
			menu.setNextX(menu.x + Combined_Width );
			//Combined_Width += font.getStringWidth(Item_Database[People[Player].inventory[i]].name) +16
			Combined_Width+= 8*10
		//	}
		//else { menu.setNextX(menu.x); }
		menu.setNextY(menu.y + 16 * y);					
			
		descriptions.push(Item_Database[People[Player].inventory[i]].description)
		menu.addText(Item_Database[People[Player].inventory[i]].name,  function() 
			{ 
				menu.slide (16, 16, -300, 16, 200);
				menu.done = true; 
				//Abort(i)

				Item_Database[People[Player].inventory[menu.selection-1]].action(menu.selection-1); 
				
				UpdateMapEngine()

			
				return 
			});

		if ( x < 2 ) x++
		else { x = 0; Combined_Width = 0; y++; }				
	}

	menu.preRender = function() {
		//map.blit(0,0)  
		RenderMap()
		GameWindowStyle.drawWindow(menu.x,menu.y,240,180)
		//menu.getFont().drawText(16+menu.getX(), GetScreenHeight() - 32, descriptions[menu.selection]);
		menu.getFont().drawTextBox(16+menu.getX(), GetScreenHeight() - 32,290,40,0, descriptions[menu.selection]);
	}

	menu.slide (-300, 180,16, 16,  200);
	
	menu.execute();
	return;
}

///////////////////////////////////////////////////////////

function LevelMenu(map)
{
	RemoveWeaponMod()
	
	var str_cost = Math.floor( ( People[Player].str*(People[Player].str*3) ) + ( (People[Player].dex+People[Player].lck)*3 ) )
	var dex_cost = Math.floor( ( People[Player].dex*(People[Player].dex*2) ) + ( (People[Player].str+People[Player].lck)*1.3 ) )
	var lck_cost = Math.floor( ( People[Player].lck*(People[Player].lck*1.5) ) + ( (People[Player].dex+People[Player].str)*2 ) )

	AddWeaponMod()
	
	var menu = DefaultMapMenu(16, 16, 320, 180);
	var descriptions = ["Return to the menu", "Increases your strength", "Increases your Dexterity", "Increases your Luck"];
  
	menu.addText("Return",  function() { menu.slide (16, 16, -160, 16, 200); menu.done = true; });
	menu.addText("Str: "+str_cost+"xp",  function() 
	{ 
		People[Player].xp -= str_cost
		People[Player].str++;
		menu.slide (16, 16, -160, 16, 200); 
		menu.done = true; 
	});

	menu.items[menu.items.length - 1].isSelectable = function() { if (People[Player].xp >= str_cost) return true }	
	menu.addText("Dex: "+dex_cost+"xp",  function() 
	{ 
		People[Player].xp -= dex_cost
		People[Player].dex++;
		menu.slide (16, 16, -160, 16, 200); 
		menu.done = true; 
	});
	menu.items[menu.items.length - 1].isSelectable = function() { if (People[Player].xp >= dex_cost) return true }			
	menu.addText("Lck: "+lck_cost+"xp",  function() 
	{ 
		People[Player].xp -= lck_cost
		People[Player].lck++;
		menu.slide (16, 16, -160, 16, 200); 
		menu.done = true; 
	});
	menu.items[menu.items.length - 1].isSelectable = function() { if (People[Player].xp >= lck_cost) return true }			
 

	menu.preRender = function() {
		//map.blit(0,0)  
		RenderMap()
		GameWindowStyle.drawWindow(menu.getX(), menu.getY(), menu.getWidth(), menu.getHeight())
		GameWindowStyle.drawWindow(menu.getX()+128, menu.getY(), 96, 144)
		menu.getFont().drawText(128+menu.getX(),16,"HP: "+People[Player].hp+"/"+People[Player].getMaxHP())
		menu.getFont().drawText(128+menu.getX(),32,"----------")
		menu.getFont().drawText(128+menu.getX(),48,"STR: "+People[Player].str)
		menu.getFont().drawText(128+menu.getX(),64,"DEX: "+People[Player].dex)
		menu.getFont().drawText(128+menu.getX(),80,"LCK: "+People[Player].lck)
		menu.getFont().drawText(128+menu.getX(),96,"----------")
		menu.getFont().drawText(128+menu.getX(),112,"EXP: "+People[Player].xp)
		menu.getFont().drawText(128+menu.getX(),144,"Gold: "+People[Player].gold)		
		menu.getFont().drawText(16+menu.getX(), GetScreenHeight() - 32, descriptions[menu.selection]);
	}

	menu.slide (-160, 16, 16, 16, 200);
	menu.execute();
	return;
}

function TextBox(x, y, w, text)
{
	Update_Rate = 100/10
	Next_Update = GetTime() + Update_Rate	
	
	var text_box = DefaultMapMenu(16,16)
  
	var r1 = CreateColor(255,255,255)
	var r2 = CreateColor(255,255,255)
  	
  	text_box.addTextBox(text, 
  		function(){
  			text_box.slide (x, y, (x-w)*2, y, 200);
  			text_box.preRender();
  			text_box.draw();
  			text_box.done = true;
  		}, 
		w,
  		font,
		r1,
  		r2,
 		LoadImage("blank.png"));

  	//menu.addText("Inventory", function() { menu.slide (16, 16, -160, 16, 200); InventoryMenu(map); menu.slide (-160, 16, 16, 16, 200);  });

	text_box.preRender = function() {
		if (GetTime() > Next_Update)
		{		
			Music.Update()
			Next_Update = GetTime() + Update_Rate
		}
		RenderMap()
		GameWindowStyle.drawWindow(text_box.getX(), text_box.getY(), text_box.getWidth(), text_box.getHeight())
  	}

	text_box.slide ((x-w)*2, y,x, y,  200);

  	return text_box.execute();
}

///////////////////////////////////////////////////////////

function ChoiceBox(choices)
{
	DrawTimer = false;
	UnselectableColor = CreateColor(219, 236, 245);
	var window = LoadWindowStyle("window.rws")
	
  	var menu = DefaultMapMenu(16, 16);

	for (var i = 0; i < choices.length; i++)
	{
		menu.addText(choices[i], function() {
			menu.slide (16, 16, -160, 16, 200);
			menu.done = true;
		});
	}

  

	menu.preRender = function() {
		RenderMap();
		window.drawWindow(menu.getX(), menu.getY(), menu.getWidth(), menu.getHeight());
		window.drawWindow(menu.getX()+128, menu.getY(), 96, 144);
		menu.getFont().drawText(128+menu.getX(),16,"HP: "+People[Player].hp+"/"+People[Player].getMaxHP());
		menu.getFont().drawText(128+menu.getX(),32,"---------- ");
		menu.getFont().drawText(128+menu.getX(),48,"STR: "+People[Player].str);
		menu.getFont().drawText(128+menu.getX(),64,"DEX: "+People[Player].dex);
		menu.getFont().drawText(128+menu.getX(),80,"LCK: "+People[Player].lck);
		menu.getFont().drawText(128+menu.getX(),96,"----------");
		menu.getFont().drawText(128+menu.getX(),112,"EXP: "+People[Player].xp);
		menu.getFont().drawText(128+menu.getX(),144,"Gold: "+People[Player].gold);
	}

	menu.slide (-160, 16, 16, 16, 200);

	menu.execute();

	DrawTimer = true;
	
	return menu.selection - 1;
}

///////////////////////////////////////////////////////////

function SellMenu(p)
{
	var menu = DefaultMapMenu(16, 16,240,180);
	var descriptions = ["Back to the status window"];
	
	menu.addDefaultGridKeys(1, 3);
	menu.vertical = false;
	menu.horizontal = true;

	var x = 0
	var Combined_Width = 0
	var y = 0
	menu.setNextX(menu.x + Combined_Width );
	menu.setNextY(menu.y + 16 * y);					  

  	menu.addText("Return",  function() { menu.slide (16, 16, -300, 16, 200); menu.done = true; });
  	x+=1 
	Combined_Width+= 8*10
  
	for (var i = 0; i < People[Player].inventory.length; i++)
	{
		//if (x != 0)
		//	{
				menu.setNextX(menu.x + Combined_Width );
				//Combined_Width += font.getStringWidth(Item_Database[People[Player].inventory[i]].name) +16
				Combined_Width+= 8*10
		//	}
		//else { menu.setNextX(menu.x); }
		
		menu.setNextY(menu.y + 16 * y);					
		
		v = Math.floor(Item_Database[People[Player].inventory[i]].value/2)
			
		descriptions.push("I'll pay "+v+" gold for that item!")
		menu.addText(Item_Database[People[Player].inventory[i]].name,  function() 
		{ 
			menu.slide (16, 16, -300, 16, 200);
			menu.done = true; 
			//Abort(i)
					
			People[p].inventory.push(People[Player].inventory[menu.selection-1])
			People[Player].gold += Math.floor(Item_Database[People[Player].inventory[menu.selection-1]].value/2)
			People[Player].inventory.splice(menu.selection-1,1)
					
				
			//Item_Database[People[Player].inventory[menu.selection-1]].action(menu.selection-1); 
					
			UpdateMapEngine()


					
			return 
		});
		
		if ( x < 2 ) x++
		else { x = 0; Combined_Width = 0; y++; }				
	}
  
  	menu.preRender = function() {
		RenderMap()
		GameWindowStyle.drawWindow(menu.x,menu.y,240,180)
		//menu.getFont().drawText(16+menu.getX(), GetScreenHeight() - 32, descriptions[menu.selection]);
		menu.getFont().drawTextBox(16+menu.getX(), GetScreenHeight() - 32,290,40,0, descriptions[menu.selection]);
	}
  
	menu.slide (-300, 180,16, 16,  200)
	
	menu.execute()
	return;

}

///////////////////////////////////////////////////////////

function BuyMenu(p)
{
	var menu = DefaultMapMenu(16, 16,240,180);
	var descriptions = ["Back to the status window"];
	
   	menu.addDefaultGridKeys(1, 3);
	menu.vertical = false;
	menu.horizontal = true;

	var x = 0;
	var Combined_Width = 0;
  	var y = 0;

	menu.setNextX(menu.x + Combined_Width );
	menu.setNextY(menu.y + 16 * y);					  

	menu.addText("Return",  function() { menu.slide (16, 16, -300, 16, 200); menu.done = true; });
	x+=1 
	Combined_Width+= 8*10
  
	for (var i = 0; i < People[p].inventory.length; i++)
	{
		//if (x != 0)
		//	{
				menu.setNextX(menu.x + Combined_Width );
				//Combined_Width += font.getStringWidth(Item_Database[People[Player].inventory[i]].name) +16
				Combined_Width+= 8*10
		//	}
		//else { menu.setNextX(menu.x); }
		menu.setNextY(menu.y + 16 * y);					
			
		v = Item_Database[People[p].inventory[i]].value
			
		descriptions.push("That item costs "+v+" gold!")
		menu.addText(Item_Database[People[p].inventory[i]].name,  function() 
			{ 
				menu.slide (16, 16, -300, 16, 200); 
				menu.done = true; 
				//Abort(i);

				if (People[Player].gold >= Item_Database[People[p].inventory[menu.selection-1]].value)
				{
					People[Player].gold -= Item_Database[People[p].inventory[menu.selection-1]].value;
					People[Player].inventory.push(People[p].inventory[menu.selection-1]);
					People[p].inventory.splice(menu.selection-1,1);
				}
				else
				{
					TextBox(30,30,220,"You can't afford it!");
				}
				//Item_Database[People[Player].inventory[menu.selection-1]].action(menu.selection-1);
				
				UpdateMapEngine();
					
			return 
		});
			
		if ( x < 2 ) x++
		else { x = 0; Combined_Width = 0; y++; }				
	}

	menu.preRender = function() {
		RenderMap();
		GameWindowStyle.drawWindow(menu.x,menu.y,240,180);
    		//menu.getFont().drawText(16+menu.getX(), GetScreenHeight() - 32, descriptions[menu.selection]);
    		menu.getFont().drawTextBox(16+menu.getX(), GetScreenHeight() - 32,290,40,0, descriptions[menu.selection]);
  	}
	
	menu.slide (-300, 180,16, 16,  200);
	
	menu.execute();
	return;
}

///////////////////////////////////////////////////////////


